#!/bin/bash

echo "Loading Temporary SPL"
sunxi-fel spl sunxi-spl.bin
echo "Loading Temporary U-Boot"
sunxi-fel -p write 0x4a000000 u-boot-dtb-temporary.bin
echo "Loading Permanent SPL Stages"
sunxi-fel -p write 0x42000000 sunxi-spl-with-ecc-toshiba.bin
sunxi-fel -p write 0x43000000 sunxi-spl-with-ecc-hynix.bin
echo "Loading Permanent U-Boot"
sunxi-fel -p write 0x43400000 u-boot-dtb-perm.img
echo "Loading Flash Script"
sunxi-fel -p write 0x44300000 flash_bootloader.scr
echo "Executing U-Boot"
sunxi-fel exe 0x4a000000
echo "When Device finishes it will shut down automatically. Please take the"
echo "device out of FEL mode, insert USB with root image, and power it back"
echo "on to continue the flashing process."
